'''a script to resize images to sizes suitable for email
(c) 2008 Edward Cannon, availble under the terms of the accompanying license'''
from Tkinter import *
import tkFileDialog
import Image, ImageTk, ImageFont, ImageDraw

def getDefault():
    im = Image.new("RGB", (250,187), "#fff")
    try:
        font = ImageFont.truetype("arial.ttf", 25)
    except IOError:
        font = ImageFont.load_default()
    x,y = font.getsize("Choose an Image")
    draw = ImageDraw.Draw(im)
    draw.text((125-x/2, 94-y/2), "Choose an Image", font=font, fill="#000")
    return im
    

class app(Tk):
    def __init__(self):
        Tk.__init__(self)
        self.make_widgets()
        self.mainloop() #must be last line in __init__
    def make_widgets(self):
        self.pimage = ImageTk.PhotoImage(getDefault())
        self.imlabel = Label(master=self, image=self.pimage)
        self.imlabel.grid(row=0,column=0,rowspan=10)
        Button(master=self, text="choose image", command=self.get_file).grid(row=0,column=1)
        self.size = StringVar(value="500")
        Entry(master=self, width=5, textvariable=self.size).grid(row=1, column=1)
        Button(master=self, text="save email image", command=self.save).grid(row=2,column=1)
    def get_file(self):
        self.fname = tkFileDialog.askopenfilename()
        if self.fname is None:
            return #process was canceled
        #else
        self.image = Image.open(self.fname)
        self.image2 =Image.open(self.fname)
        self.image2.thumbnail((250,250), Image.ANTIALIAS)
        self.pimage = ImageTk.PhotoImage(self.image2)
        self.imlabel['image'] = self.pimage
    def save(self):
        bname, temp, ext = self.fname.rpartition(".")
        name = bname + "email." + ext
        name = tkFileDialog.asksaveasfilename(initialfile=name)
        if name is None:
            return #process was canceled
        size = int(self.size.get())
        self.image.thumbnail((size,size), Image.ANTIALIAS)
        self.image.save(name)

if __name__ == "__main__":
    app()
